IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'CPJ_Localidades_Duplicadas') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE dbo.CPJ_Localidades_Duplicadas
END
GO

CREATE PROCEDURE [dbo].[CPJ_Localidades_Duplicadas] @pJson VARCHAR(8000)
AS 
SET NOCOUNT ON

	DECLARE @pFecha_Desde		DATE
	DECLARE @pFecha_Hasta		DATE
	DECLARE @Id_Evento_Grupo	INT

	SET @pFecha_Desde			= ISNULL(CONVERT(DATE, dbo.CF_JSON_VALUE(@pJson,'Fecha_Desde')), CONVERT(DATE,GETDATE()))
	SET @pFecha_Hasta			= ISNULL(CONVERT(DATE, dbo.CF_JSON_VALUE(@pJson,'Fecha_Hasta')), CONVERT(DATE,GETDATE()))
	SET @Id_Evento_Grupo		= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Evento_Grupo')), 0)

	SET @pFecha_Hasta = DATEADD(DAY,1,@pFecha_Hasta)

BEGIN TRY

	SELECT * INTO #LISTAS FROM Prod_Listas_Precios WHERE Id_Evento_Grupo = @Id_Evento_Grupo

	SELECT i.id_producto, COUNT(*) AS Cantidad
	INTO #zDuplicados_20220317_3
	FROM cbtes c, cbtes_items i
	WHERE 
	c.id_trans=i.id_trans
	AND c.id_lista IN (SELECT Id_Lista_Precio FROM #LISTAS)
	AND c.Id_Estado_Cbte not in (0, 3)
	AND CONVERT(DATE, i.fecha_qa) < @pFecha_Hasta
	AND CONVERT(DATE, i.fecha_venc) >= @pFecha_Desde
	AND Flag_QA = 'A'
	GROUP BY i.id_producto
	HAVING COUNT(*) > 1

	SELECT c.id_trans, dbo.CF_Cbte_Descrip(C.Id_Trans) AS Cbte, C.Lote, CONVERT(DATE, c.fecha) AS Fecha_Cbte, E.Descripcion, c.id_lista, PLP.Descripcion AS Lista,  CONVERT(DATE, i.fecha_qa) AS Fecha_Desde, CONVERT(DATE, i.fecha_venc) AS Fecha_Hasta, i.id_cliente, t.razon_social, i.id_producto, PR.Descripcion_Detallada AS Producto, PR.Calle AS Sector, PR.Fila, PR.Columna AS Asiento
	INTO #zDupl_20220317_3
	FROM cbtes c, cbtes_items i, clientes t, Prod_Listas_Precios PLP, Productos PR, Cbtes_Estados E
	WHERE 
	c.id_trans=i.id_trans
	AND i.id_cliente=t.id_cliente
	AND C.Id_Estado_Cbte = E.Id_Estado_Cbte
	AND PR.Id_Producto = I.Id_Producto
	AND C.Id_Lista = PLP.Id_Lista_Precio
	AND Flag_QA = 'A'
	AND I.Id_Producto <> ''
	and i.Id_Producto in (SELECT id_producto FROM #zDuplicados_20220317_3)
	AND c.Id_Estado_Cbte not in (0, 3)
	AND c.id_lista IN (SELECT Id_Lista_Precio FROM Prod_Listas_Precios WHERE Id_Lista_Precio in (SELECT Id_Lista_Precio FROM #LISTAS))
	AND CONVERT(DATE, i.fecha_qa) < @pFecha_Hasta
	AND CONVERT(DATE, i.fecha_venc) >= @pFecha_Desde
	ORDER BY I.Id_Producto

	SELECT DISTINCT Id_Cliente, A.Cbte, A.Descripcion AS Estado_Cbte, Razon_Social, Id_Producto, Fecha_Cbte, Id_Lista, Lote, t.Id_Trans
	FROM #zDupl_20220317_3 a, transacciones t,Cbtes_Aplica ca
	where a.Id_Trans = t.Id_Trans
	and ca.Id_Trans=t.Id_Trans
	and a.Id_Trans=ca.Id_Trans
	ORDER BY Id_Producto, t.Id_Trans

END TRY  
BEGIN CATCH  

    EXECUTE usp_GetErrorInfo
	RETURN 9999

END CATCH

RETURN 0
